package gov.va.med.mhv.health.repository;

import gov.va.med.mhv.health.model.Allergy;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AllergyRepository extends JpaRepository<Allergy, Long> {
	
	
    @Query("select a from Allergy a where a.userprofileId = :userprofileid order by a.eventDate desc")
	 List<Allergy>  getAllergiesForUser(@Param ("userprofileid") Long userprofileid);
    
    
    @Query("select a from Allergy a where a.userprofileId = :userprofileid order by a.eventDate desc")
	 List<Allergy>  getDashBoardAllergiesForUser(@Param ("userprofileid") Long userprofileid,Pageable page);


}
